// this sets the background color of the master UIView (when there are no windows/tab groups on it)
Titanium.UI.setBackgroundColor('#000');


// step 9
// create an empty Window which we will use for the Title Screen.
// a Window is an empty container that can be opened or closed.
// to fill the container with image content we create a View and then add it to the Window.
var windowTitle = Titanium.UI.createWindow({
    width: 1024,
    height: 768,
	fullscreen: true,
    orientationModes: [Titanium.UI.LANDSCAPE_RIGHT]
});

// a View used as a BG for the Title Screen Window.
var viewTitleBG = Titanium.UI.createView({
    top: 0,
	left: 0,
	width: '100%',
	height: '100%',
	backgroundImage: './iphone/iDefuse_title.png'
});


// step 10
// create two Buttons used for navigation on the Title Screen.
// note that they feature properties similar to CSS
var buttonPlay = Titanium.UI.createButton({
	top: 310,
	left: 455,
	width: 120,
	height: 40,
	backgroundImage:''	// makes the button opacity 0 but still enabled
});

var buttonInstructions = Titanium.UI.createButton({
	top: 410,
	left: 410,
	width: 220,
	height: 40,
	backgroundImage:''	// makes the button opacity 0 but still enabled
});

// create an empty Window which we will use for the Game Screen
// for now we won't add anything to it, it will just remain empty
var windowGame = Titanium.UI.createWindow({
	width: 1024,
	height: 768,
	fullscreen: true
});

// here we add the View and Buttons to our empty Title Screen Window.
windowTitle.add(viewTitleBG);
windowTitle.add(buttonInstructions);
windowTitle.add(buttonPlay);

// Windows offer the ability to Open and Close, so after we have completed
// adding all of the objects to the Window we can open() it so the user can
// see the Window
windowTitle.open();


// Step 11
// create a counter that tracks which screen we display in the instructions
// Window, whenever we click next this will get incremented by 1
var instructionCounter = 1;

// create another Window and a View (for BG image) for the Instructions Screen
var windowInstructions = Titanium.UI.createWindow({
	width: 1024,
	height: 768,
	fullscreen: true
});
var viewInstructions = Titanium.UI.createView({
	width: '100%',
	height: '100%',
	
	// notice we construct the image name to load from the counter
	backgroundImage: './iphone/iDefuse-intro' + instructionCounter + '.png'
});

// create a next Button that will be added to the Instructions Window
var buttonNextInstructions = Titanium.UI.createButton({
	width: 120,
	height: 55,
	top: 685,
	left: 870,
	backgroundImage: ''
});

// add the View and Buttons to the Instruction Window
windowInstructions.add(viewInstructions);
windowInstructions.add(buttonNextInstructions);

// here we attach an Event Listener to the next button inside the Instructions Window so that
// it increases the instructionCounter by one and updates the backgroundImage of the viewInstructions
// View, or close the Window if at the last screen (or the counter equals 6)
buttonNextInstructions.addEventListener('click', function(e)
{
	instructionCounter++;
	
	if(instructionCounter < 7)
	{
		viewInstructions.backgroundImage = './iphone/iDefuse-intro' + instructionCounter + '.png';
	} else
	{
		// reset the counter and View BG to defaults ready for next time and close the Window
		instructionCounter = 1;
		viewInstructions.backgroundImage = './iphone/iDefuse-intro' + instructionCounter + '.png';
		windowInstructions.close();
	}
	
});

// lastly attach EventListeners to the Buttons in the Title screen
// to either open the Game Window or the Instructions Window
buttonInstructions.addEventListener('click', function(e) {
	windowInstructions.open();
});

buttonPlay.addEventListener('click', function(e) {
	windowGame.open();
});