﻿package com
{
	import flash.display.*;
	import flash.events.*;
	import flash.utils.*;
	import flash.filesystem.*;
	import com.styles.*;
	import com.adobe.images.PNGEncoder;
	
	
	
	public class Main extends MovieClip
	{
		private var _style			:Joining; 						// The design style class.
		private var _folderName		:String	= "type/"; 				// The folder name for the saved designs.
		private var _fileName		:String	= "type"; 				// The saved file name.
		private var _positions		:Array = new Array(); 			// The pixel positions of the letter shape.
		private var _graphicHolder	:MovieClip = new MovieClip(); 	// The movielcip the design bitmap is placed into.
		private var _libItem		:MovieClip;						// The letter item in the library.
		private var _pixelSize		:int = 8;						// The pixel grid we will be using to scane the letter.
		private var _centerX		:int = stage.stageWidth * 0.5; 	// The center of the stage width.
		private var _centerY		:int = stage.stageHeight * 0.5; // The center of the stage height.
		private var _bmd			:BitmapData; 					// The design bitmap data.
		private var _bmp			:Bitmap; 						// The design bitmap.
		
		
		
		public function Main():void
		{
			// This is the letter movieclip in the library.
			_libItem = new letter();
			
			
			// Height and width of the letter.
			var itemWidth:int	= _libItem.width;
			var itemHeight:int 	= _libItem.height;
			
			
			// Create a bitmap of the letter.
			//It's this bitmap that will be used to scan for the pixel scanning.
			var bmd:BitmapData = new BitmapData(itemWidth, itemHeight, false, 0x000000);
			bmd.draw(_libItem);
			
			
			// Scan through the pixels which gap is set by the _pixelSize variable.
			for (var xNum:int = 0; xNum < itemWidth; xNum += _pixelSize)
			{
				for (var yNum:int = 0; yNum < itemHeight; yNum += _pixelSize)
				{
					// The pixel colour.
					var pixelColour:Number = bmd.getPixel(xNum, yNum);
					
					// The pixel colour isn't black, so must be a pixel form the letter.
					if(pixelColour != 0)
					{
						// Store the pixels X and Y position.
						var obj:Object = new Object();
						obj.x = xNum;
						obj.y = yNum;
						_positions.push(obj);
					}
				}
			}
			
			
			// Listen out for a key being pressed.
			stage.addEventListener(KeyboardEvent.KEY_DOWN, keyDownHandler);
			
			
			initStyle();
		}
		
		
		
		private function initStyle():void
		{
			// Create new letter graphic style.
			
			_style = new Joining();
			
			_style.addEventListener('update', eventHandler);
			
			_style.init(_libItem, _positions);
		}
		
		
		
		private function eventHandler(e:Event):void
		{
			// Texture/effect class has completed 
			
			_style.removeEventListener('update', eventHandler);
			
			
			// Add letter graphic style to the graphic holder.
			_graphicHolder.addChild(_style);
			
			
			_style.x = _centerX - (_style.width * 0.5);
			_style.y = _centerY - (_style.height * 0.5);
			
			
			_bmd = new BitmapData(stage.stageWidth, stage.stageHeight, false, 0x000000);
			_bmp = new Bitmap(_bmd);
			_bmd.draw(_graphicHolder);
			
			addChild(_bmp);
		}
		
		
		
		private function keyDownHandler(e:KeyboardEvent) : void
		{
			var key:int = e.keyCode;
			
			if (key == 82)
			{
				// The R key has been pressed.
				// Refresh the design.
				reset();
			}
			else if (key == 83)
			{
				// The S key has been pressed.
				// Save the design.
				saveDesign();
			}
		}
		
		
		
		private function reset():void
		{
			// Create a new design and clear the last design.
			
			_style.removeEventListener('update', eventHandler);
			
			removeChild(_bmp);
			_graphicHolder.removeChild(_style);
			
			initStyle();
		}
		
		
		
		private function saveDesign():void
		{
			// Save the design as a PNG.
			
			var arrBytes:ByteArray = PNGEncoder.encode(_bmd);
			var file:File = File.desktopDirectory.resolvePath(_folderName + _fileName + ".png");
			var fileStream:FileStream = new FileStream();
			fileStream.open(file, FileMode.WRITE);
			fileStream.writeBytes(arrBytes);
			fileStream.close();
		}
	}
}