﻿package com.styles
{
	import flash.display.*;
	import flash.events.*;
	import flash.utils.*;
	import flash.filters.*;
	import flash.geom.ColorTransform;
	
	
	public class Graphic extends MovieClip
	{
		private var _colours	:Array = new Array(0x000000, 0xffffff, 0xff015b, 0x00fef);
		private var _graphics	:Array = new Array(dot, line, triangle);
		private var _item		:MovieClip;
		private var _shape		:Object;
		private var _libItem	:Object;
		
		
		
		public function init(libItem:Object, positions:Array):void
		{
			_libItem = libItem;
			
			for(var i:uint; i < positions.length; i++)
			{
				// Add a random item from the library.
				var itemNum:int = Math.random() * _graphics.length;
				_item 	= new _graphics[itemNum];
				_shape 	= _item.getChildAt(0);
				
				
				// Position library graphic at the stored position.
				_item.x = positions[i].x;
				_item.y = positions[i].y;
				
				
				// Position library graphic at a random position around the stored position.
				_item.x = (Math.random() * 10) + (positions[i].x - 5);
				_item.y = (Math.random() * 10) + (positions[i].y - 5);
				
				
				// Colour library graphic.
				colourItem();
				
				
				// Scale library graphic.
				scaleItem();
				
				
				// Rotate library graphic.
				rotateItem();
				
				
				// Add shadow to library graphic.
				shadowItem();
				
				
				// Add library graphic to the stage.
				addChild(_item);
			}
			
			
			dispatchEvent(new Event('update'));
		}
		
		
		
		private function colourItem():void
		{
			// Colour library graphic.
			var colour:int 						= Math.random() * _colours.length;
			var colTrans:ColorTransform 		= _shape.transform.colorTransform;
			colTrans.color 						= _colours[colour];
			_shape.transform.colorTransform 	= colTrans;
		}
		
		
		
		private function scaleItem():void
		{
			// Scale library graphic.
			var scale:Number = (Math.random() * 0.7) + 0.3;
			_item.scaleX = scale;
			_item.scaleY = scale;
		}
		
		
		
		private function rotateItem():void
		{
			// Rotate library graphic at a set angle.
			//_item.rotation = 45;

			
			// Rotate library graphic randomly.
			_item.rotation = Math.random() * 360;
				
			
			// Rotate library graphic around the center point of the letter.
			/*var dx:Number 	= _item.x - (_libItem.width * 0.5);
			var dy:Number 	= _item.y - (_libItem.height * 0.5);
			_item.rotation 	= Math.atan2(dy, dx) * 180 / Math.PI;*/
		}
		
		
		
		private function shadowItem():void
		{
			// Add shadow to library graphic.
			var shad:DropShadowFilter = new DropShadowFilter();  
			shad.color 		= 0x000000;
			shad.blurY 		= 4;
			shad.blurX 		= 4;
			shad.angle 		= 180;
			shad.alpha 		= 0.5;
			shad.distance 	= 3;
			var filtersArray:Array = new Array(shad);  
			_item.filters = filtersArray;
		}
	}
}