package
{
	import flash.display.Bitmap;
	import flash.display.Loader;
	import flash.display.LoaderInfo;
	import flash.display.Sprite;
	import flash.display.StageAlign;
	import flash.display.StageScaleMode;
	import flash.events.Event;
	import flash.events.GeolocationEvent;
	import flash.events.ProgressEvent;
	import flash.events.StatusEvent;
	import flash.geom.Point;
	import flash.net.URLRequest;
	import flash.sensors.Geolocation;
	import flash.text.TextField;
	
	public class Main extends Sprite
	{
		private const MAX_ACCEPTED_DISTANCE						:int									= 12; // The maximum distance to accept when making accuracy checks. (In meters)
		private const ZOOM_LEVEL								:int 									= 17; 
		private const MAP_WIDTH									:int									= 340;
		private const MAP_HEIGHT								:int									= 510;
		
		private const PIXEL_LAT									:Number									= 0.000005975453044949379; // Latitude value of one pixel at zoom level 17
		private const PIXEL_LNG									:Number									= 0.000010728836059570313; // Longitude value of one pixel at zoom level 17
		
		private var _latitude									:Number;
		private var _longitude									:Number;
		private var _upperLeftLat								:Number;
		private var _upperLeftLng								:Number;
		
		private var _geolocation								:Geolocation;
		private var _mapLoader									:Loader;
		private var _mapBitmap									:Bitmap;
		private var _character									:Sprite;
		private var _ready										:Boolean;
		private var _updateCharPos								:Boolean;
		
		public function Main()
		{
			stage.align = StageAlign.TOP_LEFT;
			stage.scaleMode = StageScaleMode.NO_SCALE;
			
			_character = new Sprite();
			_character.graphics.beginFill(0xFF0000, .7);
			_character.graphics.drawCircle(0,0,10);
			_character.graphics.endFill();
			addChild(_character);
			
			getGeolocation();
		}
		
		private function getGeolocation():void
		{
			if(Geolocation.isSupported == true)
			{
				_geolocation = new Geolocation();
				_geolocation.setRequestedUpdateInterval(100);
				_geolocation.addEventListener(GeolocationEvent.UPDATE, geoUpdateHandler);
			}
			else
			{
				// Your device does not support geolocation
			}
		}
		
		private function geoUpdateHandler(e:GeolocationEvent):void
		{
			var latitude:Number = e.latitude;
			var longitude:Number = e.longitude;
			var horizontalAccuracy:Number = e.horizontalAccuracy;
			var verticalAccuracy:Number = e.verticalAccuracy;
			var charPosition:Object;
			
			if( horizontalAccuracy <= MAX_ACCEPTED_DISTANCE && verticalAccuracy <= MAX_ACCEPTED_DISTANCE )
			{
				_latitude = latitude;
				_longitude = longitude;
				
				if(!_ready)
				{
					_ready = true;
					getStaticMap();
				}
				else if(_updateCharPos)
				{
					charPosition = getPixelPosition( _latitude, _longitude );
					_character.x = charPosition.x;
					_character.y = charPosition.y;
				}
			}
		}
		
		private function getStaticMap():void
		{
			_upperLeftLat = _latitude + ( ( PIXEL_LAT * MAP_HEIGHT ) * .5 );
			_upperLeftLng = _longitude - ( ( PIXEL_LNG * MAP_WIDTH ) * .5 );
			
			var fileRequest:URLRequest;
			fileRequest = new URLRequest( "http://maps.google.com/maps/api/staticmap?" + 
			"sensor=false&size="+ MAP_WIDTH + "x" + MAP_HEIGHT +
			"&center=" + _latitude + "," + _longitude + 
			"&zoom=" + ZOOM_LEVEL );
			
			_mapLoader = new Loader();
			_mapLoader.contentLoaderInfo.addEventListener(Event.COMPLETE, mapLoaded);
			_mapLoader.load(fileRequest);
		}
		
		private function mapLoaded(e:Event):void
		{
			var bmp:Bitmap = Bitmap( e.target.content );
			addChildAt(bmp,0);
			
			_updateCharPos = true;
		}
		
		private function getPixelPosition(latitude:Number, longitude:Number):Object
		{
			var pos:Object = {};
			
			var latDistance:Number = Math.abs( latitude - _upperLeftLat );
			var lngDistance:Number = longitude - _upperLeftLng;
			
			pos.y = Math.round( latDistance / PIXEL_LAT );
			pos.x = Math.round( lngDistance / PIXEL_LNG );  
			
			return pos;
		}
		
		
	}
}